#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Line FractalMod01.fsh   by   scry
//https://www.shadertoy.com/view/NtX3zl
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.085  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//#define iTime iTime*0.5

mat2 r2d(float a) {
    return mat2(cos(a),sin(a),-sin(a),cos(a));
}

float line(vec2 uvu, float l, float w) {
    return smoothstep(w, 0.,abs(uvu.x-0.5)-0.005)*smoothstep(0.001,0.,abs(uvu.y-0.5)-l);
}


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = fragCoord/iResolution.xy;
    vec2 R = iResolution.xy;
    float ar = R.x/R.y;
    uv -= 0.5;
    uv.x *= ar;
    uv += 0.5;
    //
    // Time varying pixel color
    vec3 col = vec3(0.);
    //col.r += smoothstep(0.01,0.,abs(uv.x-0.5));
    //col.r *= smoothstep(0.01,0.,abs(uv.y-0.5)-0.4);
    uv -= 0.5;
    float c = length(uv);
    float cc = c;
    //uv.y -= 0.5;
    //uv = abs(uv)-(sin(iTime*0.5)*0.5+0.5)*0.5;
    //uv = abs(uv);
    //uv = fract(uv);
    //uv.x += 0.5;
    //c = fract(c);
    //uv.x += iTime;
    uv = vec2(log(c),atan(uv.x,uv.y));
    //uv.x *= 0.1;
    //uv.x *= 0.5;
    //uv.x /= c;
    uv.x -= sin(c+iTime*0.25);
    //uv.x -= sin(uv.y*4.+iTime);
    uv.x *= 0.5;
    //uv.x *= 2.;
    uv.x -= iTime;
    //uv.x *= 0.5;
    uv.x += 1.;
    //uv = abs(uv)-0.5;
    //uv *= r2d(iTime*0.1);
    //uv.x  = abs(uv.x);
    //uv.y *= 4./3.14;
    float vt = uv.x;
    //vt = c*20.;
    //float sy = float(int(fract(uv.x*0.05)*4.+0.9));
    float sy = floor(fract(uv.x*0.05)*4.+0.9);
    //uv.x -= sin(uv.y+iTime)*0.2;
    //sy = floor(fract(uv.x)*4.);
    //uv.x /= 8.-sy;
    //uv.x *= .0000001;
    //uv *= 0.25;
    uv.y *= sy/3.14;
    vt += iTime*0.025;
    float ux = uv.x;
    //vt += iTime+uv.y*0.1;
    //uv.y *= 4./3.14;
   // vt *= c*0.001;
    //uv.x -= iTime;
    //float vt = uv.x;
    uv = fract(uv)-0.5;
    c = length(uv);
    //uv = vec2(log(c),atan(uv.x,uv.y))*0.1;
    //uv.x += iTime;
    //uv.y *= 2.;
    //uv.x += 1.5;
    //uv.x += 0.5;
    int steps = 8;
    //float c = length(uv);
    //uv -= 0.5;
    //uv = abs(uv+0.5)-0.5;
    //uv += 0.5;
    int s2 = 6;
    s2 = int(mod(ux*1.,18.));
    for (int i=0;i<s2;i++) {
        uv = abs(uv)-(sin(vt*0.5)*0.5+0.5)*0.5;
        uv *= r2d(float(i)+vt);
    }
    //uv -= 0.5;
    //uv += 0.5;
    //float c = length(uv);
    uv *= r2d(sin(c*8.*sin(vt*0.5)+vt*0.5));
    for (int i=0;i<steps;i++) {
        uv *= r2d(-vt*0.1);
        col.r += line(uv+0.5,0.4,(sin(uv.x*04.91)*0.5+0.5)*0.01)*21.;
    }
    
    //col.r -= 4.5;
    //col.r = fract(col.r*0.01+iTime*0.1);
    //col.r *= 0.01;
    //col.r = sin(col.r+iTime*0.1);
    col.bg = col.rr;
    col.r *= 0.05;
    col.r += ux*0.2;
    //col.r -= iTime*4.;
    col = vec3(sin(col.r),cos(col.r+0.2),cos(-col.r))*0.8;
    //col = sin(col+uv.x);
    // Output to screen
    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

